/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.designer;

import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.apps.designer.VWDesignerCoreData;
import filenet.vw.apps.designer.VWPrintableWorkflowCollectionProperty;
import filenet.vw.apps.designer.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.IVWPrintable;
import filenet.vw.toolkit.utils.VWPrinter;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.dialog.VWModelessDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class VWPrintProgressDialog
extends VWModelessDialog
implements ActionListener,
Runnable {
    private static final Dimension DIM_DEFAULT_SIZE = new Dimension(450, 175);
    private JLabel m_workflowNameLabel = null;
    private JProgressBar m_progressBar = null;
    private JButton m_cancelButton = null;
    private boolean m_bUserCanceled = false;
    private boolean m_bCanClose = false;
    private VWPrintableWorkflowCollectionProperty m_collPrintable = null;
    private VWWorkflowDefinition[] m_wflDefs = null;
    private boolean m_bDisplayPrintDialog = false;
    private VWPrinter m_vwPrinter = null;
    private VWDesignerCoreData m_designerCoreData = null;

    public VWPrintProgressDialog(VWDesignerCoreData designerCoreData) {
        super(designerCoreData.getParentFrame(), (VWSessionInfo)null);
        this.m_designerCoreData = designerCoreData;
        this.setTitle(VWResource.s_printProgressDialogTitle);
        this.setSize(DIM_DEFAULT_SIZE);
        this.setLocationRelativeTo(designerCoreData.getParentFrame());
        this.createControls();
    }

    public void setVisible(boolean bVisible) {
        super.setVisible(bVisible);
        if (!bVisible) {
            this.m_parentContainer.setEnabled(true);
        }
    }

    public void printWorkflows(VWPrintableWorkflowCollectionProperty collPrintable, VWWorkflowDefinition[] wflDefs, boolean bDisplayPrintDialog) {
        this.m_collPrintable = collPrintable;
        if (wflDefs != null && wflDefs.length > 0) {
            this.m_wflDefs = new VWWorkflowDefinition[wflDefs.length];
            System.arraycopy(wflDefs, 0, this.m_wflDefs, 0, wflDefs.length);
        }
        this.m_bDisplayPrintDialog = bDisplayPrintDialog;
        this.m_vwPrinter = this.m_designerCoreData.getTabbedCanvasPanel().getVWPrinter(null);
        this.m_workflowNameLabel.setText(null);
        this.m_progressBar.setValue(0);
        this.m_bUserCanceled = false;
        this.m_bCanClose = false;
        this.setVisible(true);
        Thread printerThread = new Thread((Runnable)this, "VWPrintProgressDialog");
        printerThread.start();
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object source = event.getSource();
            if (source.equals(this.m_cancelButton)) {
                if (this.m_bCanClose) {
                    Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(this, 201));
                } else {
                    this.m_bUserCanceled = true;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                this.m_parentContainer.setEnabled(false);
                boolean bContinue = true;
                if (this.m_collPrintable != null) {
                    IVWPrintable vwPrintable = this.m_vwPrinter.getCurrentPrintable();
                    this.m_vwPrinter.setupPrintable(this.m_collPrintable);
                    this.m_progressBar.setMinimum(0);
                    this.m_progressBar.setMaximum(this.m_wflDefs.length + 1);
                    this.m_workflowNameLabel.setText(VWResource.s_packagePropertiesDialogTitle);
                    Thread.yield();
                    bContinue = this.m_vwPrinter.print(this.m_bDisplayPrintDialog);
                    this.m_bDisplayPrintDialog = false;
                    this.m_progressBar.setValue(this.m_progressBar.getValue() + 1);
                    this.m_vwPrinter.setupPrintable(vwPrintable);
                } else {
                    this.m_progressBar.setMinimum(0);
                    this.m_progressBar.setMaximum(this.m_wflDefs.length);
                }
                if (bContinue) {
                    if (this.m_wflDefs.length == 1) {
                        this.m_cancelButton.setEnabled(false);
                        this.m_workflowNameLabel.setText(this.m_wflDefs[0].getName());
                        this.m_vwPrinter = this.m_designerCoreData.getTabbedCanvasPanel().getVWPrinter(this.m_wflDefs[0].getName());
                        Thread.yield();
                        this.m_vwPrinter.print(this.m_bDisplayPrintDialog);
                        this.m_progressBar.setValue(this.m_progressBar.getValue() + 1);
                    } else {
                        for (int nRowIndex = 0; nRowIndex < this.m_wflDefs.length && !this.m_bUserCanceled; ++nRowIndex) {
                            this.m_workflowNameLabel.setText(this.m_wflDefs[nRowIndex].getName());
                            this.m_vwPrinter = this.m_designerCoreData.getTabbedCanvasPanel().getVWPrinter(this.m_wflDefs[nRowIndex].getName());
                            Thread.yield();
                            if (!this.m_vwPrinter.print(this.m_bDisplayPrintDialog)) break;
                            this.m_bDisplayPrintDialog = false;
                            this.m_progressBar.setValue(this.m_progressBar.getValue() + 1);
                        }
                    }
                }
                Object var4_5 = null;
                this.m_bCanClose = true;
            }
            catch (Exception ex) {
                System.out.println("Exception in VWPrintProgressDialog::run - " + ex.getMessage());
                Object var4_6 = null;
                this.m_bCanClose = true;
                this.m_cancelButton.setEnabled(true);
                this.m_cancelButton.doClick();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.m_bCanClose = true;
            this.m_cancelButton.setEnabled(true);
            this.m_cancelButton.doClick();
            throw throwable;
        }
        this.m_cancelButton.setEnabled(true);
        this.m_cancelButton.doClick();
    }

    private void createControls() {
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.getContentPane().add((Component)this.createMainPanel(), "Center");
        this.getContentPane().add((Component)this.createButtonPanel(), "Last");
    }

    private JPanel createMainPanel() {
        try {
            JPanel mainPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.anchor = 10;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(6, 6, 6, 6);
            mainPanel.add((Component)new JLabel(VWResource.s_printing), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.gridwidth = 0;
            this.m_workflowNameLabel = new JLabel();
            mainPanel.add((Component)this.m_workflowNameLabel, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            this.m_progressBar = new JProgressBar(0);
            mainPanel.add((Component)this.m_progressBar, gbCons);
            return mainPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createButtonPanel() {
        try {
            JPanel buttonPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.anchor = 10;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(6, 6, 6, 6);
            this.m_cancelButton = new JButton(VWResource.s_close);
            this.m_cancelButton.setName("m_cancelButton_VWPrintProgressDialog");
            this.m_cancelButton.addActionListener(this);
            buttonPanel.add((Component)this.m_cancelButton, gbCons);
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }
}

